/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCTabButton;
import jclass.bwt.JCTabManager;
import jclass.bwt.TabArrowPanel;
import jclass.util.JCVector;

public class TabPanel
extends JCContainer {
    JCTabManager tab_manager;
    TabArrowPanel arrow_panel;
    int tab_height;
    int tab_width;
    int pref_width;
    JCVector buttons = new JCVector(0);
    private static final String base = "tabpanel";
    private static int nameCounter;
    Component focus_target;

    public TabPanel(JCTabManager jCTabManager) {
        this.setName(base + nameCounter++);
        this.tab_manager = jCTabManager;
        this.double_buffer = true;
        this.setLayout(null);
        this.enable11Events(8L);
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    synchronized void setTabShape(int n) {
        int n2 = 0;
        while (n2 < this.countComponents()) {
            if (this.getComponents()[n2] instanceof JCTabButton) {
                ((JCTabButton)this.getComponents()[n2]).setShape(n);
            }
            ++n2;
        }
        this.layout();
        this.repaint();
    }

    int countTabs() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.countComponents()) {
            if (this.getComponents()[n2] instanceof JCTabButton) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private void findLargestTab() {
        Component[] componentArray = this.getComponents();
        this.tab_width = 0;
        this.tab_height = 0;
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCTabButton) {
                Dimension dimension = this.getTabSize((JCTabButton)componentArray[n]);
                this.tab_height = Math.max(this.tab_height, dimension.height);
                if (this.tab_manager.tab_resize) {
                    this.tab_width = Math.max(this.tab_width, dimension.width);
                }
            }
            ++n;
        }
    }

    Dimension getTabSize(JCTabButton jCTabButton) {
        Font font = JCTabButton.getCurrentTabFont(this.tab_manager);
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(font);
        Font font2 = jCTabButton.getFont();
        FontMetrics fontMetrics2 = jCTabButton.getToolkit().getFontMetrics(font2);
        if (fontMetrics.getHeight() > fontMetrics2.getHeight() || fontMetrics.charWidth('W') > fontMetrics2.charWidth('W')) {
            font2 = font;
        }
        jCTabButton.setLabelSize(jCTabButton.getLabel(), font2);
        Dimension dimension = jCTabButton.preferredSize();
        if (font2 == font) {
            jCTabButton.setLabelSize(jCTabButton.getLabel(), jCTabButton.getFont());
        }
        dimension.width += 4;
        dimension.height += 4;
        return dimension;
    }

    int getTabSpacing() {
        int n = this.tab_manager.tab_spacing;
        if (n == -999) {
            if (this.tab_manager.getTabShape() == 0) {
                n = 0;
            } else if (this.tab_manager.getTabShape() == 1) {
                n = -this.getComponents()[0].preferredSize().height / 2;
            }
        }
        return n;
    }

    public synchronized void layout() {
        if (this.getPeer() == null || this.countTabs() == 0 || this.size().height == 0) {
            return;
        }
        this.findLargestTab();
        int n = this.getTabSpacing();
        if (this.tab_manager.tab_stretch && (this.tab_width + n) * this.countTabs() < this.size().width) {
            this.tab_width = this.size().width / this.countTabs() - n * Math.max(0, this.countTabs() - 1);
        }
        if (this.tab_width > 1) {
            --this.tab_width;
        }
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < this.tab_manager.first_tab && n2 < componentArray.length) {
            componentArray[n2].hide();
            ++n2;
        }
        int n3 = 0;
        int n4 = this.size().height;
        this.tab_manager.last_tab = this.tab_manager.first_tab;
        int n5 = this.size().width;
        if (this.pref_width > this.size().width) {
            n5 -= 37;
        }
        int n6 = this.tab_manager.first_tab;
        while (n6 < componentArray.length) {
            if (componentArray[n6] instanceof JCTabButton) {
                int n7;
                JCTabButton jCTabButton = (JCTabButton)componentArray[n6];
                int n8 = n7 = this.tab_width > 0 ? this.tab_width - 1 : this.getTabSize((JCTabButton)jCTabButton).width;
                if (n3 == 0) {
                    n3 = jCTabButton.shadow;
                }
                int n9 = 0;
                if (this.tab_manager.getTabSide() == 1) {
                    n9 = jCTabButton.shadow;
                }
                if (!jCTabButton.current_tab) {
                    jCTabButton.reshape(n3, n9, n7, n4 - jCTabButton.shadow);
                } else {
                    jCTabButton.reshape(n3 - jCTabButton.shadow, 0, n7 + 2 * jCTabButton.shadow, n4);
                }
                jCTabButton.show();
                n3 += n7 + n;
                if (jCTabButton.location().x + jCTabButton.size().width < n5) {
                    this.tab_manager.last_tab = n6;
                }
            }
            ++n6;
        }
        if (this.tab_manager.first_tab == 0 && this.pref_width <= this.size().width) {
            if (this.arrow_panel != null) {
                this.remove(this.arrow_panel);
                return;
            }
        } else {
            if (this.arrow_panel == null) {
                this.arrow_panel = new TabArrowPanel(this);
            }
            this.add(this.arrow_panel);
            this.arrow_panel.layout();
        }
    }

    boolean allTabsVisible() {
        return this.arrow_panel == null || !this.arrow_panel.isVisible();
    }

    public Dimension preferredSize() {
        this.findLargestTab();
        int n = this.getTabSpacing();
        this.pref_width = 0;
        if (this.tab_width == 0) {
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof JCTabButton) {
                    this.pref_width += componentArray[n2].preferredSize().width + n;
                }
                ++n2;
            }
        } else {
            this.pref_width = this.tab_width * this.countTabs() + n * Math.max(0, this.countTabs() - 1);
        }
        return new Dimension(this.pref_width, this.tab_height);
    }

    void addButton(JCTabButton jCTabButton) {
        if (!this.buttons.contains(jCTabButton)) {
            this.buttons.addElement(jCTabButton);
        }
    }

    private void removeButton(JCTabButton jCTabButton) {
        if (this.buttons.contains(jCTabButton)) {
            this.buttons.removeElement(jCTabButton);
        }
    }

    public Component add(Component component, int n) {
        if (component instanceof JCTabButton) {
            this.addButton((JCTabButton)component);
        }
        return super.add(component, n);
    }

    public void remove(Component component) {
        boolean bl;
        if (component.getParent() != this) {
            return;
        }
        super.remove(component);
        if (!(component instanceof JCTabButton)) {
            return;
        }
        JCTabButton jCTabButton = (JCTabButton)component;
        boolean bl2 = bl = component.getPeer() != null;
        if (component.getPeer() != null) {
            component.removeNotify();
        }
        if (this.buttons.contains(component)) {
            this.buttons.removeElement(component);
        }
        jCTabButton.tab_panel = null;
        jCTabButton.tab_manager = null;
        jCTabButton.page = null;
        if (bl) {
            Rectangle rectangle = component.bounds();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.layout();
    }

    void toFront(Component component) {
        if (component.getParent() == this && component instanceof JCTabButton) {
            this.removeButton((JCTabButton)component);
            this.addButton((JCTabButton)component);
        }
    }

    public Component locate(int n, int n2) {
        if (!this.inside(n, n2)) {
            return null;
        }
        int n3 = this.buttons.size() - 1;
        while (n3 >= 0) {
            JCTabButton jCTabButton = (JCTabButton)this.buttons.elementAt(n3);
            if (jCTabButton != null && jCTabButton.isVisible() && jCTabButton.inside(n - jCTabButton.location().x, n2 - jCTabButton.location().y)) {
                return jCTabButton;
            }
            --n3;
        }
        return this;
    }

    void restoreStackingOrder() {
        if (this.buttons.size() == 0) {
            return;
        }
        Component[] componentArray = this.getComponents();
        JCVector jCVector = new JCVector(this.buttons.size());
        boolean bl = false;
        if (componentArray.length != this.buttons.size()) {
            bl = true;
        }
        int n = 0;
        while (n < componentArray.length) {
            if (!bl && componentArray[n] != this.buttons.elementAt(n)) {
                bl = true;
            }
            if (this.buttons.contains(componentArray[n])) {
                jCVector.addElement(componentArray[n]);
            }
            ++n;
        }
        if (bl) {
            this.buttons = jCVector;
            this.repaint();
        }
    }

    public void repaint() {
        this.repaint(0, 0, this.size().width, this.size().height);
    }

    private void paintChild(Graphics graphics, JCTabButton jCTabButton) {
        Point point = BWTUtil.translateToParent(this, jCTabButton, 0, 0);
        Dimension dimension = jCTabButton.size();
        if (!this.getPaintRect().intersects(new Rectangle(point, dimension))) {
            return;
        }
        jCTabButton.setDoubleBuffer(false);
        Point point2 = jCTabButton.location();
        Graphics graphics2 = graphics.create(point2.x, point2.y, dimension.width, dimension.height);
        jCTabButton.paint(graphics2);
        graphics2.dispose();
        jCTabButton.setDoubleBuffer(true);
    }

    public void paintInterior(Graphics graphics) {
        this.getPaintRect();
        graphics.setColor(this.getBackground());
        int n = 0;
        while (n < this.buttons.size()) {
            JCTabButton jCTabButton = (JCTabButton)this.buttons.elementAt(n);
            if (jCTabButton.isShowing()) {
                this.paintChild(graphics, jCTabButton);
            }
            ++n;
        }
    }

    private void sendEvent(Component component, Event event) {
        event.target = component;
        int n = event.x;
        int n2 = event.y;
        Point point = BWTUtil.translateFromParent(this, component, 0, 0);
        event.translate(point.x, point.y);
        component.postEvent(event);
        event.x = n;
        event.y = n2;
    }

    boolean dispatchEvent(Component component, Event event, int n) {
        if (component == null) {
            return false;
        }
        event.target = component;
        int n2 = event.id;
        event.id = n;
        this.sendEvent(component, event);
        event.id = n2;
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.target != this) {
            return true;
        }
        Component component = this.locate(event.x, event.y);
        if (component != null && !component.isEnabled()) {
            component = null;
        }
        if (component == null || component == this) {
            return true;
        }
        this.dispatchEvent(component, event, event.id);
        if (component instanceof JCComponent && ((JCComponent)component).isTraversable() && component != this.focus_target) {
            if (this.focus_target != null) {
                this.dispatchEvent(this.focus_target, event, 1005);
            }
            this.focus_target = component;
            this.dispatchEvent(component, event, 1004);
        }
        this.requestFocus();
        return true;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        switch (n) {
            case 401: {
                int n2;
                if (keyEvent.isActionKey()) {
                    n = 403;
                }
                if ((n2 = keyEvent.getKeyCode()) == 16 || n2 == 17 || n2 == 18) {
                    return;
                }
                Event event = JCComponent.convertEvent(this, keyEvent);
                this.keyDown(event, event.key);
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public boolean keyDown(Event event, int n) {
        if (event.target != this) {
            return false;
        }
        boolean bl = this.dispatchEvent(this.focus_target, event, event.id);
        if (!bl) {
            bl = super.keyDown(event, n);
        }
        return bl;
    }

    public boolean keyUp(Event event, int n) {
        if (event.target != this) {
            return false;
        }
        boolean bl = this.dispatchEvent(this.focus_target, event, event.id);
        if (!bl) {
            bl = super.keyUp(event, n);
        }
        return bl;
    }
}

